<?php
/*--------------------------------------------------------------
   Item.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\DropdownItemTitles;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown\Item\Value;

class Item
{
    /**
     * @var Value
     */
    private $value;
    
    /**
     * @var DropdownItemTitles
     */
    private $titles;
    
    
    /**
     * Constructor.
     */
    private function __construct(Value $value, DropdownItemTitles $titles)
    {
        $this->value  = $value;
        $this->titles = $titles;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Value $value, DropdownItemTitles $titles): self
    {
        return new self($value, $titles);
    }
    
    
    /**
     * Return value.
     */
    public function value(): Value
    {
        return $this->value;
    }
    
    
    /**
     * Return titles.
     */
    public function titles(): DropdownItemTitles
    {
        return $this->titles;
    }
}